unit PrintDoc;

interface

uses
  System.Drawing,
  System.Drawing.Printing,
  System.IO,
  Controls;

type
  { Application main form }
  TTextFilePrintDocument = class(PrintDocument)
  private
    FPrintFont: System.Drawing.Font;
    FStreamReader: StreamReader;
  protected
    procedure OnBeginPrint(pe: PrintEventArgs); override;
    procedure OnPrintPage(pe: PrintPageEventArgs); override;
  public
    constructor Create(AStream: StreamReader);
    destructor Destroy; override;
  end;

implementation

{ TTextFilePrintDocument }

constructor TTextFilePrintDocument.Create(AStream: StreamReader);
begin
  inherited Create;
  FStreamReader:= AStream;
end;

destructor TTextFilePrintDocument.Destroy;
begin
  // Old habits die hard...
  FStreamReader.Free;
  FPrintFont.Free;
  inherited;
end;

procedure TTextFilePrintDocument.OnBeginPrint(pe: PrintEventArgs);
begin
  inherited;
  FPrintFont:= System.Drawing.Font.Create('Arial', 10);
end;

procedure TTextFilePrintDocument.OnPrintPage(pe: PrintPageEventArgs);
var
  lpp, yPos: Single;
  Count: Integer;
  leftMargin, topMargin: Single;
  line: string;
begin
  inherited;
  count:= 0;
  leftMargin:= pe.MarginBounds.Left;
  topMargin:= pe.MarginBounds.Top;
  line:= '';

  //Work out the number of lines per page
  //Use the MarginBounds on the event to do this
  lpp:= pe.MarginBounds.Height / FPrintFont.GetHeight(pe.Graphics) ;

  //Now iterate over the file printing out each line
  //NOTE WELL: This assumes that a single line is not wider than the page width
  //Check count first so that we don't read line that we won't print
  line:= FStreamReader.ReadLine;
  while (count < lpp) and ( line <>  '') do
  begin
    yPos:= topMargin + (count * FPrintFont.GetHeight(pe.Graphics));
    pe.Graphics.DrawString(line, FPrintFont, Brushes.Black, leftMargin, yPos, StringFormat.Create);
    Inc(count);
    line:= FStreamReader.ReadLine;
  end;

  //If we have more lines then print another page
  if (line <> '') then
    pe.HasMorePages:= True
  else
    pe.HasMorePages:= False;
end;

end.
